<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddIndexToFlightsComUserViews extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('flights__com_user_views', function (Blueprint $table) {
            $table->index("flight_com_id", "flights__com_user_views_flight_com_id");
            $table->index("flight_com_details_id", "flights__com_user_views_flight_com_details_id");
            $table->index("user_id", "flights__com_user_views_user_id");
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('flights__com_user_views', function (Blueprint $table) {
            $table->dropIndex([
                "flights__com_user_views_flight_com_id",
                "flights__com_user_views_flight_com_details_id",
                "flights__com_user_views_user_id",
            ]);
        });
    }
}
