<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddIndexToFlightsComCheckin extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('flights__com_checkin', function (Blueprint $table) {
            $table->index("flight_com_id", "flights__com_checkin_flight_com_id");
            $table->index("flight_com_details_id", "flights__com_checkin_flight_com_details_id");
            $table->index("flight_id", "flights__com_checkin_flight_id");
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('flights__com_checkin', function (Blueprint $table) {
            $table->dropIndex([
                "flights__com_checkin_flight_com_id",
                "flights__com_checkin_flight_com_details_id",
                "flights__com_checkin_flight_id",
            ]);
        });
    }
}
