<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddFieldsToUsersTracking extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('users__tracking', function (Blueprint $table) {
            $table->boolean("many_attempts")->nullable()->after("id");
            $table->string("email")->nullable()->after("many_attempts");
            $table->string("dp")->nullable()->after("user_id");
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('users__tracking', function (Blueprint $table) {
            $table->dropColumn([
                "many_attempts",
                "email",
                "dp",
            ]);
        });
    }
}
