<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class ChangePaxFToPaxAInFlightsCom extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('flights__com', function (Blueprint $table) {
            $table->dropColumn([
                "pax_f",
                "pax_c",
                "pax_y",
                "pax_adult",
                "pax_male",
                "pax_female",
                "pax_child",
                "pax_inf",
            ]);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('flights__com', function (Blueprint $table) {
            $table->unsignedInteger("pax_f")->nullable()->after("pos");
            $table->unsignedInteger("pax_c")->nullable()->after("pax_f");
            $table->unsignedInteger("pax_y")->nullable()->after("pax_c");

            $table->unsignedInteger("pax_adult")->nullable()->after("pax_y");
            $table->unsignedInteger("pax_male")->nullable()->after("pax_adult");
            $table->unsignedInteger("pax_female")->nullable()->after("pax_male");
            $table->unsignedInteger("pax_child")->nullable()->after("pax_female");
            $table->unsignedInteger("pax_inf")->nullable()->after("pax_child");
        });
    }
}
