<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class DropCheckinColumnsFromFlightsComDetails extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('flights__com_details', function (Blueprint $table) {
            $table->dropColumn([
                "gate",
                "pos",
                "pax_f",
                "pax_c",
                "pax_y",
                "pax_adult",
                "pax_male",
                "pax_female",
                "pax_child",
                "pax_inf",
                "seat_a",
                "seat_b",
                "seat_c",
                "seat_d",
                "seat_e",
                "chkd_bag_pcs",
                "chkd_bag_wt",
                "gate_bag_pcs",
                "gate_bag_wt",
                "notoc_rmks",
                "trc_rmks",
                "spvr_rmks",
            ]);


        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('flights__com_details', function (Blueprint $table) {
            $table->string("gate")->nullable()->after("flight_com_id");
            $table->string("pos")->nullable()->after("gate");

            $table->unsignedInteger("pax_f")->nullable()->after("pos");
            $table->unsignedInteger("pax_c")->nullable()->after("pax_f");
            $table->unsignedInteger("pax_y")->nullable()->after("pax_c");

            $table->unsignedInteger("pax_adult")->nullable()->after("pax_y");
            $table->unsignedInteger("pax_male")->nullable()->after("pax_adult");
            $table->unsignedInteger("pax_female")->nullable()->after("pax_male");
            $table->unsignedInteger("pax_child")->nullable()->after("pax_female");
            $table->unsignedInteger("pax_inf")->nullable()->after("pax_child");

            $table->unsignedInteger("seat_a")->nullable()->after("pax_inf");
            $table->unsignedInteger("seat_b")->nullable()->after("seat_a");
            $table->unsignedInteger("seat_c")->nullable()->after("seat_b");
            $table->unsignedInteger("seat_d")->nullable()->after("seat_c");
            $table->unsignedInteger("seat_e")->nullable()->after("seat_d");

            $table->unsignedInteger("chkd_bag_pcs")->nullable()->after("seat_e");
            $table->unsignedInteger("chkd_bag_wt")->nullable()->after("chkd_bag_pcs");

            $table->unsignedInteger("gate_bag_pcs")->nullable()->after("chkd_bag_wt");
            $table->unsignedInteger("gate_bag_wt")->nullable()->after("gate_bag_pcs");

            $table->text("notoc_rmks")->nullable()->after("message");
            $table->text("trc_rmks")->nullable()->after("notoc_rmks");
            $table->text("spvr_rmks")->nullable()->after("trc_rmks");
        });
    }
}
