<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateFlightsComCheckin extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('flights__com_checkin', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');
            $table->unsignedInteger("flight_com_id")->nullable();
            $table->unsignedInteger("flight_com_details_id")->nullable();
            $table->unsignedInteger("flight_id")->nullable();

            $table->string("gate")->nullable();
            $table->string("pos")->nullable();

            $table->unsignedInteger("aircraft_id")->nullable();
            $table->unsignedInteger("capacity_c")->nullable();
            $table->unsignedInteger("capacity_y")->nullable();

            $table->unsignedInteger("pax_a_booked")->nullable();
            $table->unsignedInteger("pax_c_booked")->nullable();
            $table->unsignedInteger("pax_y_booked")->nullable();
            $table->unsignedInteger("pax_inf_booked")->nullable();

            $table->unsignedInteger("pax_a")->nullable();
            $table->unsignedInteger("pax_c")->nullable();
            $table->unsignedInteger("pax_y")->nullable();
            $table->unsignedInteger("pax_inf")->nullable();

            $table->unsignedInteger("pax_adults")->nullable();
            $table->unsignedInteger("pax_m")->nullable();
            $table->unsignedInteger("pax_f")->nullable();
            $table->unsignedInteger("pax_ch")->nullable();

            $table->unsignedInteger("seat_a")->nullable();
            $table->unsignedInteger("seat_b")->nullable();
            $table->unsignedInteger("seat_c")->nullable();
            $table->unsignedInteger("seat_d")->nullable();
            $table->unsignedInteger("seat_e")->nullable();

            $table->unsignedInteger("chkd_bag_pcs")->nullable();
            $table->unsignedInteger("chkd_bag_wt")->nullable();

            $table->unsignedInteger("gate_bag_pcs")->nullable();
            $table->unsignedInteger("gate_bag_wt")->nullable();

            $table->text("ckin_ctr")->nullable();
            $table->text("ckin_rmks")->nullable();
            $table->text("trc_rmks")->nullable();
            $table->text("spvr_rmks")->nullable();

            $table->unsignedInteger('created_by')->nullable();
            $table->unsignedInteger('updated_by')->nullable();
            $table->nullableTimestamps();
            $table->timestamp('deleted_at')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('flights__com_checkin');
    }
}
