<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateFlightsComFlightsPts extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('flights__com_flights_pts', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');

            $table->unsignedInteger("flight_com_id")->nullable();
            $table->unsignedInteger("flight_com_details_id")->nullable();
            $table->unsignedInteger("flight_id")->nullable();

            $table->string("jetway_steps")->nullable();
            $table->time("jetway_on")->nullable();
            $table->time("first_pax_off")->nullable();
            $table->time("last_pax_off")->nullable();
            $table->time("cleaners_onboard")->nullable();
            $table->time("fuelling_started")->nullable();
            $table->time("pre_boarding_started")->nullable();
            $table->time("cleaners_off")->nullable();
            $table->time("pilot_headset")->nullable();
            $table->time("board_pax")->nullable();
            $table->time("all_pax_onboard")->nullable();
            $table->time("gatebags_collected")->nullable();
            $table->time("loadsheet_onboard")->nullable();
            $table->time("all_doors_closed")->nullable();
            $table->time("tug_connected")->nullable();
            $table->time("jetway_off")->nullable();
            $table->time("pushback")->nullable();
            $table->time("final_walk_around")->nullable();

            $table->boolean("back_steps_used")->nullable();
            $table->integer("cabin_bags_checkin")->nullable();
            $table->integer("cabin_bags_gate")->nullable();

            $table->integer("mhb_ahl")->nullable();
            $table->integer("mhb_ohd")->nullable();
            $table->integer("mhb_dpr")->nullable();

            $table->unsignedInteger('created_by')->nullable();
            $table->unsignedInteger('updated_by')->nullable();
            $table->nullableTimestamps();
            $table->timestamp('deleted_at')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('flights__com_flights_pts');
    }
}
