<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateFlightsComFlightsStaff extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('flights__com_flights_staff', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');

            $table->unsignedInteger("flight_com_id")->nullable();
            $table->unsignedInteger("flight_com_details_id")->nullable();
            $table->unsignedInteger("flight_id")->nullable();

            $table->unsignedInteger("user_id")->nullable();
            $table->unsignedInteger("staff_roster_id")->nullable();
            $table->unsignedInteger("service_id")->nullable();
            $table->string("service_type")->nullable();
            $table->dateTime("planned_report_time")->nullable();
            $table->dateTime("planned_release_time")->nullable();
            $table->dateTime("report_time")->nullable();
            $table->dateTime("release_time")->nullable();
            $table->string("reason")->nullable();

            $table->nullableTimestamps();
            $table->unsignedInteger('created_by')->nullable();
            $table->unsignedInteger('updated_by')->nullable();
            $table->timestamp("deleted_at")->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('flights__com_flights_staff');
    }
}
