<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddNotocDetailsToFlightsContainers extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('flights__containers', function (Blueprint $table) {
            $table->text("notoc_details")->nullable()->after("notoc");

            $table->unsignedInteger('created_by')->nullable();
            $table->unsignedInteger('updated_by')->nullable();
            $table->nullableTimestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('flights__containers', function (Blueprint $table) {
            //
            $table->dropColumn([
                "notoc_details",
                "created_by",
                "updated_by",
                "created_at",
                "updated_at",
            ]);
        });
    }
}
