<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateFlightsComContainers extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('flights__com_containers', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');
            $table->unsignedInteger("flight_com_id")->nullable();
            $table->unsignedInteger("flight_com_details_id")->nullable();

            $table->string("pos")->nullable();
            $table->string("content")->nullable();
            $table->string("type")->nullable();
            $table->string("num")->nullable();
            $table->unsignedInteger("pcs")->nullable();
            $table->unsignedInteger("wt")->nullable();
            $table->unsignedInteger("vr")->nullable();
            $table->boolean("notoc")->nullable();

            $table->unsignedInteger('created_by')->nullable();
            $table->unsignedInteger('updated_by')->nullable();
            $table->nullableTimestamps();
            $table->timestamp('deleted_at')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('flights__com_containers');
    }
}
