<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateFlightsCom extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('flights__com', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');
            $table->unsignedInteger("flight_id")->nullable();
            $table->string("key")->nullable();

            $table->unsignedInteger("pax_f")->nullable();
            $table->unsignedInteger("pax_c")->nullable();
            $table->unsignedInteger("pax_y")->nullable();

            $table->unsignedInteger("pax_adult")->nullable();
            $table->unsignedInteger("pax_male")->nullable();
            $table->unsignedInteger("pax_female")->nullable();
            $table->unsignedInteger("pax_child")->nullable();
            $table->unsignedInteger("pax_inf")->nullable();

            $table->unsignedInteger("seat_a")->nullable();
            $table->unsignedInteger("seat_b")->nullable();
            $table->unsignedInteger("seat_c")->nullable();
            $table->unsignedInteger("seat_d")->nullable();
            $table->unsignedInteger("seat_e")->nullable();

            $table->unsignedInteger("chkd_bag_pcs")->nullable();
            $table->unsignedInteger("chkd_bag_wt")->nullable();

            $table->unsignedInteger("gate_bag_pcs")->nullable();
            $table->unsignedInteger("gate_bag_wt")->nullable();

            $table->unsignedInteger('created_by')->nullable();
            $table->unsignedInteger('updated_by')->nullable();
            $table->nullableTimestamps();
            $table->timestamp('deleted_at')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('flights__com');
    }
}
