<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddSubcategoryToModules extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('modules', function (Blueprint $table) {
            $table->string("subname")->nullable()->after("name");
            $table->string("subname_lang")->nullable()->after("lang");
            $table->string("subcategory")->nullable()->after("category_lang");
            $table->string("subcategory_lang")->nullable()->after("subcategory");
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('modules', function (Blueprint $table) {
            $table->dropColumn([
               "subname",
               "subname_lang",
               "subcategory",
               "subcategory_lang",
            ]);
        });
    }
}
