<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class DropAirportsCityIdForeignKey extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('airports', function (Blueprint $table) {
            try {
                $table->dropForeign("airports_city_id_foreign");
            }
            catch (\Doctrine\DBAL\Driver\Mysqli\MysqliException $e){
                $table->dropIndex("airports_city_id_foreign");
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('airports', function (Blueprint $table) {
            $table->foreign('city_id')
                ->references('id')
                ->on('cities')
                ->onDelete('SET NULL')
                ->onUpdate('CASCADE');
        });
    }
}
