<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddActionsDateToPassengersOrders extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('passengers__orders', function (Blueprint $table) {
            $table->date("actions_date")->nullable()->after("sales_date");
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('passengers__orders', function (Blueprint $table) {
            $table->dropColumn([
                "actions_date",
            ]);
        });
    }
}
