<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddOriginalFareToPassengersFlights extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('passengers__flights', function (Blueprint $table) {
            $table->float('original_fare', 15,3)->nullable()->after("departure_date");
            $table->unsignedInteger('original_fare_currency_id')->nullable()->after("original_fare");
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('passengers__flights', function (Blueprint $table) {
            $table->dropColumn([
                "original_fare",
                "original_fare_currency_id",
            ]);
        });
    }
}
