<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateLibraryTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('library', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');
            $table->string("name")->nullable();
            $table->string("type")->nullable();
            $table->string("abbr")->nullable();
            $table->date("issue_date")->nullable();
            $table->date("effective_date")->nullable();
            $table->string("edition_no")->nullable();
            $table->text("details")->nullable();
            $table->string("attachment_file")->nullable();

            $table->nullableTimestamps();
            $table->unsignedInteger('created_by')->nullable();
            $table->unsignedInteger('updated_by')->nullable();
            $table->timestamp("deleted_at")->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('library');
    }
}
