<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddEmailRecipientsToAirports extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('airports', function (Blueprint $table) {
            $table->text("email_recipients")->nullable()->after("position");
            $table->boolean("email_hub")->nullable()->after("email_recipients");
            $table->boolean("stop_emails")->nullable()->after("email_hub");
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('airports', function (Blueprint $table) {
            $table->dropColumn([
                "email_recipients",
                "email_hub",
                "stop_emails",
            ]);
        });
    }
}
