<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddFieldsToDelays extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('delays', function (Blueprint $table) {
            $table->text("description_ln")->nullable()->after("description");
            $table->text("explanation_ln")->nullable()->after("explanation");
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('delays', function (Blueprint $table) {
            $table->dropColumn([
                "description_ln",
                "explanation_ln",
            ]);
        });
    }
}
