<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddAdditionalFieldsToCommandsResults extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('commands__results', function (Blueprint $table) {
            $table->integer("email_parsed")->nullable()->after("found_emails");
            $table->integer("email_exists")->nullable()->after("email_parsed");
            $table->integer("email_not_matched")->nullable()->after("email_exists");
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('commands__results', function (Blueprint $table) {
            $table->dropColumn([
               "email_parsed",
               "email_exists",
               "email_not_matched",
            ]);
        });
    }
}
