<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddFieldsToFlightsContainers extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('flights__containers', function (Blueprint $table) {
            $table->boolean("from_cpm")->nullable()->after("id");
            $table->boolean("from_ucm")->nullable()->after("from_cpm");
            $table->boolean("container_matched")->nullable()->after("container_id");
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('flights__containers', function (Blueprint $table) {

            $table->dropColumn([
                "from_cpm",
                "from_ucm",
                "container_matched",
            ]);

        });
    }
}
