<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddSourceToPassengers extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('passengers', function (Blueprint $table) {
            $table->string("created_name")->nullable()->after("middle_name");
            $table->string("created_source")->nullable()->after("created_name");
            $table->string("updated_source")->nullable()->after("created_source");
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('passengers', function (Blueprint $table) {
            $table->dropColumn([
                "created_name",
                "created_source",
                "updated_source",
            ]);
        });
    }
}
