<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddFieldsToFlightsDelays extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('flights__delays', function (Blueprint $table) {
            $table->time("notification_duration")->nullable()->after("duration");
            $table->timestamp("notification_date")->nullable()->after("notification_duration");
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('flights__delays', function (Blueprint $table) {
            $table->dropColumn([
                'notification_duration',
                'notification_date',
            ]);
        });
    }
}
