<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddFromPsmToPassengersFlightsAct extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('passengers__flights_act', function (Blueprint $table) {
            $table->boolean("from_psm")->nullable()->after("from_tpm");
            $table->string("ssr")->nullable()->after("inbound");
            $table->text("ssr_info")->nullable()->after("ssr");
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('passengers__flights_act', function (Blueprint $table) {
            $table->dropColumn([
               "from_psm",
               "ssr",
               "ssr_info",
            ]);
        });
    }
}
