<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddCompartmentsFieldsToFlights extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('flights', function (Blueprint $table) {
            $table->double("cmp_total_wt")->nullable()->after("mail");
            $table->double("cmp_1_wt")->nullable()->after("cmp_total_wt");
            $table->double("cmp_2_wt")->nullable()->after("cmp_1_wt");
            $table->double("cmp_3_wt")->nullable()->after("cmp_2_wt");
            $table->double("cmp_4_wt")->nullable()->after("cmp_3_wt");
            $table->double("cmp_5_wt")->nullable()->after("cmp_4_wt");
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('flights', function (Blueprint $table) {
            $table->dropColumn([
                "cmp_total_wt",
                "cmp_1_wt",
                "cmp_2_wt",
                "cmp_3_wt",
                "cmp_4_wt",
                "cmp_5_wt",
            ]);
        });
    }
}
