<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AlterFlightsContainersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('flights__containers', function (Blueprint $table) {
            $table->dropColumn([
                "flight_id",
                "created_by",
                "created_at",
                "updated_by",
                "updated_at",
                "deleted_at",
            ]);

            $table->unsignedInteger("info_id")->nullable()->after("id");
            $table->unsignedInteger("container_type_id")->nullable()->after("container_id");
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('flights__containers', function (Blueprint $table) {
            $table->dropColumn([
                "info_id",
                "container_type_id"
            ]);

            $table->unsignedInteger('flight_id')->nullable()->after("id");

            $table->nullableTimestamps();
            $table->unsignedInteger('created_by')->nullable();
            $table->unsignedInteger('updated_by')->nullable();
            $table->timestamp('deleted_at')->nullable();
        });
    }
}
