<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateFlightsContainers extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('flights__containers', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');
            $table->unsignedInteger('flight_id')->nullable();
            $table->unsignedInteger('container_id')->nullable();
            $table->unsignedInteger('destination_airport_id')->nullable();
            $table->integer("row_number")->nullable();
            $table->string("position")->nullable();
            $table->double("weight")->nullable();
            $table->integer("vr")->nullable();
            $table->string("loaded_type")->nullable();
            $table->text("details")->nullable();

            $table->nullableTimestamps();
            $table->unsignedInteger('created_by')->nullable();
            $table->unsignedInteger('updated_by')->nullable();
            $table->timestamp('deleted_at')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('flights__containers');
    }
}
