<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateContainersTypesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('containers__types', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');
            $table->string("name")->nullable();
            $table->double("max_weight")->nullable();
            $table->double("length")->nullable();
            $table->double("width")->nullable();
            $table->double("height")->nullable();
            $table->double("length_m")->nullable();
            $table->string("picture")->nullable();
            $table->string("thumb")->nullable();
            $table->text("details")->nullable();

            $table->nullableTimestamps();
            $table->unsignedInteger('created_by')->nullable();
            $table->unsignedInteger('updated_by')->nullable();
            $table->timestamp('deleted_at')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('containers__types');
    }
}
