<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddAdditionalFieldsToAircraft extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('aircraft', function (Blueprint $table) {

            $table->integer("aisles")->nullable()->after("aircraft_type_id");
            $table->integer("noise_category")->nullable()->after("aisles");
            $table->integer("decks")->nullable()->after("noise_category");
            $table->integer("cargo_compartments")->nullable()->after("decks");
            $table->double("cargo_volume")->nullable()->after("cargo_compartments");
            $table->double("hourly_fuel_consumption")->nullable()->after("cargo_volume");

            $table->text("description")->nullable()->after("order");
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('aircraft', function (Blueprint $table) {
            $table->dropColumn([
                "aisles",
                "noise_category",
                "decks",
                "cargo_compartments",
                "cargo_volume",
                "hourly_fuel_consumption",
                "description",

            ]);
        });
    }
}
