<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddConfigAToAircraft extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('aircraft', function (Blueprint $table) {
            $table->integer("config_a")->nullable()->after("min_ccm");

            $table->text("config_a_details")->nullable()->after("config_y");
            $table->text("config_c_details")->nullable()->after("config_a_details");
            $table->text("config_y_details")->nullable()->after("config_c_details");
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('aircraft', function (Blueprint $table) {
            $table->dropColumn([
                "config_a",

                "config_a_details",
                "config_c_details",
                "config_y_details",
            ]);
        });
    }
}
