<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddFieldsToAircraftTypes extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('aircraft__types', function (Blueprint $table) {
            $table->boolean("wide_board")->nullable()->after("icao");
            $table->integer("config_a")->nullable()->after("wide_board");
            $table->integer("config_c")->nullable()->after("config_a");
            $table->integer("config_y")->nullable()->after("config_c");

            $table->text("config_a_details")->nullable()->after("config_y");
            $table->text("config_c_details")->nullable()->after("config_a_details");
            $table->text("config_y_details")->nullable()->after("config_c_details");
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('aircraft__types', function (Blueprint $table) {
            $table->dropColumn([
               "wide_board",

               "config_a",
               "config_c",
               "config_y",

               "config_a_details",
               "config_c_details",
               "config_y_details",
            ]);
        });
    }
}
