<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatePassengersFlightsAct extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('passengers__flights_act', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');
            $table->unsignedInteger('parent_id')->nullable();
            $table->unsignedInteger('passenger_id')->nullable();
            $table->unsignedInteger('flight_id')->nullable();
            $table->unsignedInteger('flight_number_id')->nullable();
            $table->unsignedInteger('passenger_order_id')->nullable();
            $table->unsignedInteger('flight_fare_basis_id')->nullable();
            $table->unsignedInteger('flight_rbd_id')->nullable();
            $table->unsignedInteger('flight_cabin_id')->nullable();
            $table->unsignedInteger('flight_order_status_id')->nullable();
            $table->unsignedInteger('passenger_frequent_flyer_id')->nullable();
            $table->integer('seq_no')->nullable();
            $table->string('group_tcp')->nullable();
            $table->string('ptm_name_str')->nullable();
            $table->integer('ptm_pax')->nullable();
            $table->string('outbound')->nullable();
            $table->string('inbound')->nullable();
            $table->integer('xbag_qty')->nullable();
            $table->integer('xbag_wt')->nullable();
            $table->string('xbag_info')->nullable();
            $table->timestamp('departure')->nullable();
            $table->date('departure_date')->nullable();

            $table->float('fare', 15,3)->nullable();
            $table->unsignedInteger('fare_currency_id')->nullable();
            $table->integer('coupon')->nullable();
            $table->string('seat_number')->nullable();
            $table->boolean('is_inf')->nullable();
            $table->boolean('baggage_is_pld')->nullable();
            $table->integer('baggage_pcs')->nullable();
            $table->float('baggage_weight', 7,2)->nullable();
            $table->text('tag_number')->nullable();
            $table->boolean('is_offload')->nullable();
            $table->string('reference_number')->nullable();
            $table->string('offload_force')->nullable();
            $table->string('offload_group')->nullable();
            $table->string('offload_rmk')->nullable();

            $table->nullableTimestamps();
            $table->unsignedInteger('created_by')->nullable();
            $table->unsignedInteger('updated_by')->nullable();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('passengers__flights_act');
    }
}
