<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddDateFieldsToAircraft extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (env(AIRLINE) != GSRM) {
            Schema::table('aircraft', function (Blueprint $table) {
                $table->timestamp("created_at")->nullable()->after("order");
                $table->timestamp("updated_at")->nullable()->after("created_at");
                $table->unsignedInteger("created_by")->nullable()->after("updated_at");
                $table->unsignedInteger("updated_by")->nullable()->after("created_by");
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        if (env(AIRLINE) != GSRM) {
            Schema::table('aircraft', function (Blueprint $table) {
                $table->dropColumn([
                   "created_at",
                   "updated_at",
                   "created_by",
                   "updated_by",
                ]);
            });
        }
    }
}
