<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddAddressTaxCodeToUsers extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('users', function (Blueprint $table) {
            $table->string("termination_reason")->nullable()->after("resigned_date");

            $table->string("tax_code")->nullable()->after("thumb");
            $table->string("address")->nullable()->after("tax_code");
            $table->unsignedInteger("address_city_id")->nullable()->after("address");
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn([
                "termination_reason",
                "tax_code",
                "address",
                "address_city_id",
            ]);
        });
    }
}
