<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddAdditionalFieldsToAirlinesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('airlines', function (Blueprint $table) {
            $table->text("focus_cities")->nullable()->after("website");
            $table->string("alliance")->nullable()->after("focus_cities");
            $table->text("subsidiaries")->nullable()->after("alliance");
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('airlines', function (Blueprint $table) {
            $table->dropColumn([
                "focus_cities",
                "alliance",
                "subsidiaries",
            ]);
        });
    }
}
