<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddFieldsToAirlinesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('airlines', function (Blueprint $table) {
            $table->dateTime("founded")->nullable()->after("thumb");
            $table->dateTime("commenced")->nullable()->after("founded");
            $table->text("operating_bases")->nullable()->after("commenced");
            $table->text("hubs")->nullable()->after("operating_bases");
            $table->text("secondary_hubs")->nullable()->after("hubs");
            $table->string("ffp")->nullable()->after("secondary_hubs");
            $table->integer("fleet_size")->nullable()->after("ffp");
            $table->integer("destinations")->nullable()->after("fleet_size");
            $table->string("slogan")->nullable()->after("destinations");
            $table->string("parent_company")->nullable()->after("slogan");
            $table->text("headquarters")->nullable()->after("parent_company");
            $table->text("key_people")->nullable()->after("headquarters");
            $table->string("employees")->nullable()->after("key_people");
            $table->string("website")->nullable()->after("employees");

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('airlines', function (Blueprint $table) {
            $table->dropColumn([
               "founded",
               "commenced",
               "operating_bases",
               "hubs",
               "secondary_hubs",
               "ffp",
               "fleet_size",
               "destinations",
               "slogan",
               "parent_company",
               "headquarters",
               "key_people",
               "employees",
               "website",
            ]);
        });
    }
}
