<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddPlannedTimesToFlightsStaff extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('flights__staff', function (Blueprint $table) {
            $table->dateTime("planned_report_time")->nullable()->after("service_type");
            $table->dateTime("planned_release_time")->nullable()->after("planned_report_time");
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('flights__staff', function (Blueprint $table) {
            $table->dropColumn(["planned_report_time", "planned_report_time"]);
        });
    }
}
