<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateFlightsTrackerDetails extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('flights__tracker_details', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');

            $table->unsignedInteger("flight_tracker_id")->nullable();
            $table->unsignedInteger("flight_id")->nullable();
            $table->timestamp("fch")->nullable();

            $table->float("fal", 8)->nullable();
            $table->float("fgs", 8)->nullable();
            $table->float("fhd", 8)->nullable();
            $table->float("fla", 16, 13)->nullable();
            $table->float("flo", 16, 13)->nullable();
            $table->float("uipla", 16, 13)->nullable();
            $table->float("uiplo", 16, 13)->nullable();
            $table->float("fdistorgtodst", 16)->nullable();
            $table->float("fdistfromorg", 16)->nullable();
            $table->float("fdisttodst", 16)->nullable();
            $table->float("fpgr", 8)->nullable();

            $table->string("usr")->nullable();
            $table->nullableTimestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('flights__tracker_details');
    }
}
