<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateFlightsTracker extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('flights__tracker', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');

            $table->string("type")->nullable();
            $table->unsignedInteger("flight_id")->nullable();
            $table->unsignedInteger("airline_id")->nullable();
            $table->unsignedInteger("flight_number_id")->nullable();
            $table->unsignedInteger("aircraft_id")->nullable();
            $table->unsignedInteger("aircraft_type_id")->nullable();

            $table->timestamp("fch")->nullable();

            $table->timestamp("std")->nullable();
            $table->timestamp("etd")->nullable();
            $table->timestamp("atd")->nullable();

            $table->timestamp("sta")->nullable();
            $table->timestamp("eta")->nullable();
            $table->timestamp("ata")->nullable();

            // Feed 4
            $table->string("status")->nullable();
            $table->integer("forgtimezone")->nullable();
            $table->integer("fdsttimezone")->nullable();

            $table->string("fat")->nullable();
            $table->string("fat_s")->nullable();
            $table->string("fat_a")->nullable();
            $table->string("forggate")->nullable();
            $table->string("forgterminal")->nullable();

            $table->string("fdstgate")->nullable();
            $table->string("fdstterminal")->nullable();
            $table->string("fdstbaggageclaim")->nullable();

            $table->string("fms")->nullable();
            $table->string("cn")->nullable();
            $table->string("fsq")->nullable();

            $table->string("forg")->nullable();
            $table->string("forgiata")->nullable();
            $table->float("forglat", 16, 13)->nullable();
            $table->float("forglon", 16, 13)->nullable();

            $table->string("fdst")->nullable();
            $table->string("fdstiata")->nullable();
            $table->float("fdstlat", 16, 13)->nullable();
            $table->float("fdstlon", 16, 13)->nullable();

            $table->float("fdistorgtodst", 16)->nullable();

            $table->string("lngapt")->nullable();
            $table->string("lngrwy")->nullable();
            $table->timestamp("lngtime")->nullable();

            $table->string("tkoapt")->nullable();
            $table->string("tkorwy")->nullable();
            $table->timestamp("tkotime")->nullable();

            $table->string("usr")->nullable();
            $table->string("usc")->nullable();
            $table->boolean("isblocked")->nullable();
            $table->string("faccat")->nullable();
            $table->string("fuscat")->nullable();
            $table->string("isga")->nullable();
            $table->text("froute")->nullable();
            $table->text("fwaypoints")->nullable();

            $table->nullableTimestamps();

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('flights__tracker');
    }
}
