<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddIcaoAndOtherFieldsToAircraftTypes extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('aircraft__types', function (Blueprint $table) {
            $table->string("icao")->nullable()->after("iata_name");
            $table->string("wake_category")->nullable()->after("policy_fcm");
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('aircraft__types', function (Blueprint $table) {
            $table->dropColumn(['icao', 'wake_category']);
        });
    }
}
