<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddFieldsToModules extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('modules', function (Blueprint $table) {
            $table->boolean("open_new_tab")->nullable()->after("name");
            $table->boolean("quick_links")->nullable()->after("open_new_tab");
            $table->string("icon")->nullable()->after("quick_links");
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('modules', function (Blueprint $table) {
            $table->dropColumn(["open_new_tab", "quick_links", "icon"]);
        });
    }
}
