<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateFlightsStations extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('flights__stations', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');

            $table->string("email_type")->nullable();
            $table->string("email_id")->nullable();
            $table->dateTime("received_datetime")->nullable();

            $table->unsignedInteger("flight_id")->nullable();
            $table->unsignedInteger("flight_number_id")->nullable();
            $table->unsignedInteger("airport_id")->nullable();
            $table->string("airport")->nullable();

            $table->integer("pax_a")->nullable();
            $table->integer("pax_c")->nullable();
            $table->integer("pax_y")->nullable();
            $table->integer("pax_inf")->nullable();

            $table->integer("pax_m")->nullable();
            $table->integer("pax_f")->nullable();
            $table->integer("pax_ch")->nullable();

            $table->integer("baggage")->nullable();
            $table->integer("baggage_pcs")->nullable();
            $table->integer("cargo")->nullable();
            $table->integer("eic")->nullable();
            $table->integer("mail")->nullable();

            $table->integer("pax_a_bkd")->nullable();
            $table->integer("pax_c_bkd")->nullable();
            $table->integer("pax_y_bkd")->nullable();
            $table->integer("pax_inf_bkd")->nullable();

            $table->nullableTimestamps();
            $table->unsignedInteger('created_by')->nullable();
            $table->unsignedInteger('updated_by')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('flights__stations');
    }
}
