<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddAirlineLicenseCheckToStaffRosterSettings extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('staff_roster__settings', function (Blueprint $table) {
            $table->boolean("airline_license_check")->nullable()->after("shift_min_rest_time");
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('staff_roster__settings', function (Blueprint $table) {
            $table->dropColumn("airline_license_check");
        });
    }
}
