<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateStaffRosterSettings extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {

        Schema::create('staff_roster__settings', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');

            $table->unsignedInteger("roster_id")->nullable();
            $table->string("staff_assignment")->nullable();
            $table->double("shift_max_hours")->nullable();
            $table->double("shift_min_hours")->nullable();
            $table->double("shift_min_rest_time")->nullable();

            $table->nullableTimestamps();

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('staff_roster__settings');
    }
}
