<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateFlightsStaff extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('flights__staff', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');

            $table->unsignedInteger("flight_id")->nullable();
            $table->unsignedInteger("user_id")->nullable();
            $table->unsignedInteger("staff_roster_id")->nullable();
            $table->unsignedInteger("service_id")->nullable();
            $table->string("service_type")->nullable();
            $table->timestamp("report_time")->nullable();
            $table->timestamp("release_time")->nullable();
            $table->string("reason")->nullable();

            $table->nullableTimestamps();
            $table->unsignedInteger('created_by')->nullable();
            $table->unsignedInteger('updated_by')->nullable();
            $table->timestamp("deleted_at")->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('flights__staff');
    }
}
