<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateStaffRosterJobs extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('staff_roster__jobs', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');

            $table->unsignedInteger("shift_id")->nullable();
            $table->unsignedInteger("staff_roster_service_id")->nullable();
            $table->unsignedInteger("flight_handler_id")->nullable();

            $table->dateTime("report_time")->nullable();
            $table->dateTime("release_time")->nullable();
            $table->double("duration")->nullable();
            $table->double("break_time")->nullable();

            $table->nullableTimestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('staff_roster__jobs');
    }
}
