<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateStaffRosterServices extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('staff_roster__services', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');

            $table->unsignedInteger("flight_handler_id")->nullable();
            $table->unsignedInteger("flight_id")->nullable();
            $table->unsignedInteger("service_id")->nullable();
            $table->string("service_type")->nullable();
            $table->integer("staff_req")->nullable();
            $table->integer("staff_min")->nullable();

            $table->dateTime("report_time")->nullable();
            $table->double("report_time_min")->nullable();
            $table->dateTime("release_time")->nullable();
            $table->double("release_time_min")->nullable();
            $table->double("duration")->nullable();

            $table->nullableTimestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('staff_roster__services');
    }
}
