<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateStaffRosterStaff extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('staff_roster__staff', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');

            $table->unsignedInteger("roster_id")->nullable();
            $table->unsignedInteger("user_id")->nullable();
            $table->string("status")->nullable();
            $table->double("total_shift_hours")->nullable();
            $table->double("max_monthly_hours")->nullable();
            $table->date("first_shift_date")->nullable();
            $table->date("last_shift_date")->nullable();

            $table->unsignedInteger("station_id")->nullable();

            $table->nullableTimestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('staff_roster__staff');
    }
}
