<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateStaffRosterFlightHandlers extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('staff_roster__flight_handlers', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');

            $table->unsignedInteger("roster_id")->nullable();
            $table->unsignedInteger("flight_id")->nullable();
            $table->unsignedInteger("station_id")->nullable();
            $table->dateTime("departure_time")->nullable();
            $table->string("departure_type")->nullable();
            $table->dateTime("arrival_time")->nullable();
            $table->string("arrival_type")->nullable();

            $table->string("service_type")->nullable();
            $table->integer("staff_req")->nullable();
            $table->integer("staff_min")->nullable();
            $table->integer("staff_act")->nullable();

            $table->nullableTimestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('staff_roster__flight_handlers');
    }
}
