<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateStaffRosterStaffLicenses extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('staff_roster__staff_licenses', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->increments('id');

            $table->unsignedInteger("staff_roster_staff_id")->nullable();
            $table->unsignedInteger("user_id")->nullable();
            $table->unsignedInteger("license_id")->nullable();
            $table->date("expiration_date")->nullable();
            $table->boolean("is_valid")->nullable();

            $table->nullableTimestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('staff_roster__staff_licenses');
    }
}
