<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddFieldsToServices extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('services', function (Blueprint $table) {

            $table->boolean("departure_service")->nullable()->after("abbr");
            $table->integer("dep_staff_req")->nullable()->after("departure_service");
            $table->integer("dep_staff_min")->nullable()->after("dep_staff_req");
            $table->integer("dep_report_time")->nullable()->after("dep_staff_min");
            $table->integer("dep_release_time")->nullable()->after("dep_report_time");

            $table->boolean("arrival_service")->nullable()->after("dep_release_time");
            $table->integer("arr_staff_req")->nullable()->after("arrival_service");
            $table->integer("arr_staff_min")->nullable()->after("arr_staff_req");
            $table->integer("arr_report_time")->nullable()->after("arr_staff_min");
            $table->integer("arr_release_time")->nullable()->after("arr_report_time");
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('services', function (Blueprint $table) {
            $table->dropColumn([
                "departure_service",
                "dep_staff_req",
                "dep_staff_min",
                "dep_report_time",
                "dep_release_time",

                "arrival_service",
                "arr_staff_req",
                "arr_staff_min",
                "arr_report_time",
                "arr_release_time",
            ]);
        });
    }
}
